//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Net.Sockets;

namespace SocketOptions
{
	/// <summary>
	/// Podsumowanie dla Class1.
	/// </summary>
	class SocketOptionsTest
	{
		static void ListRawDefaultOptions(Socket s)
		{
			Object option;
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.Debug);
			Console.WriteLine("Raw Debug {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.Broadcast);
			Console.WriteLine("Raw Broadcast {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.Error);
			Console.WriteLine("Raw Error {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.Type);
			Console.WriteLine("Raw Type {0}",
				((int)option == 1) ? "SOCK_STREAM" :
				((int)option == 2) ? "SOCK_DGRAM" :
				((int)option == 3) ? "SOCK_RAW" :
				((int)option == 4) ? "SOCK_RDM" :
				((int)option == 5) ? "SOCK_SEQPACKET" : "Nieznany typ");
			option = s.GetSocketOption(SocketOptionLevel.IP, SocketOptionName.MulticastInterface);
			Console.WriteLine("Raw MulticastInterface {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.IP, SocketOptionName.MulticastLoopback);
			Console.WriteLine("Raw MulticastLoopback {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.IP, SocketOptionName.MulticastTimeToLive);
			Console.WriteLine("Raw MulticastTimeToLive {0}", option);
		}
		static void ListUDPDefaultOptions(Socket s)
		{
			Object option;
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.Broadcast);
			Console.WriteLine("UDP Broadcast {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.Debug);
			Console.WriteLine("UDP Debug {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.IP, SocketOptionName.DontFragment);
			Console.WriteLine("UDP DontFragment {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.Error);
			Console.WriteLine("UDP Error {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.IP, SocketOptionName.MulticastInterface);
			Console.WriteLine("UDP MulticastInterface {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.IP, SocketOptionName.MulticastLoopback);
			Console.WriteLine("UDP MulticastLoopback {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.IP, SocketOptionName.MulticastTimeToLive);
			Console.WriteLine("UDP MulticastTimeToLive {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.Udp, SocketOptionName.NoChecksum);
			Console.WriteLine("UDP NoChecksum {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.Type);
			Console.WriteLine("UDP Type {0}",
				((int)option == 1) ? "SOCK_STREAM" :
				((int)option == 2) ? "SOCK_DGRAM" :
				((int)option == 3) ? "SOCK_RAW" :
				((int)option == 4) ? "SOCK_RDM" :
				((int)option == 5) ? "SOCK_SEQPACKET" : "Nieznany typ");
			option = s.GetSocketOption(SocketOptionLevel.IP, SocketOptionName.TypeOfService);
			Console.WriteLine("UDP TypeOfService {0}", option);
		}
		static void ListTCPDefaultOptions(Socket s)
		{
			Object option;
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.AcceptConnection);
			Console.WriteLine("TCP AcceptConnections {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.Tcp, SocketOptionName.BsdUrgent);
			Console.WriteLine("TCP BsdUrgent {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.Debug);
			Console.WriteLine("TCP Debug {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.DontLinger);
			Console.WriteLine("TCP DontLinger {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.DontRoute);
			Console.WriteLine("TCP DontRoute {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.Error);
			Console.WriteLine("TCP Error {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.ExclusiveAddressUse);
			Console.WriteLine("TCP ExclusiveAddressUse {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.Expedited);
			Console.WriteLine("TCP Expedited {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.IP, SocketOptionName.IpTimeToLive);
			Console.WriteLine("TCP IpTimeToLive {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.KeepAlive);
			Console.WriteLine("TCP KeepAlive {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.Linger);
			Console.WriteLine("TCP Linger {0} {1}", ((LingerOption)option).Enabled, ((LingerOption)option).LingerTime);
			option = s.GetSocketOption(SocketOptionLevel.Tcp, SocketOptionName.NoDelay);
			Console.WriteLine("TCP NoDelay {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.OutOfBandInline);
			Console.WriteLine("TCP OutOfBandInline {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.ReceiveBuffer);
			Console.WriteLine("TCP ReceiveBuffer {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.ReceiveTimeout);
			Console.WriteLine("TCP ReceiveTimeout {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.ReuseAddress);
			Console.WriteLine("TCP ReuseAddress {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.SendBuffer);
			Console.WriteLine("TCP SendBuffer {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.SendTimeout);
			Console.WriteLine("TCP SendTimeout {0}", option);
			option = s.GetSocketOption(SocketOptionLevel.Socket, SocketOptionName.Type);
			Console.WriteLine("TCP Type {0}",
				((int)option == 1) ? "SOCK_STREAM" :
				((int)option == 2) ? "SOCK_DGRAM" :
				((int)option == 3) ? "SOCK_RAW" :
				((int)option == 4) ? "SOCK_RDM" :
				((int)option == 5) ? "SOCK_SEQPACKET" : "Unknown type");
			option = s.GetSocketOption(SocketOptionLevel.IP, SocketOptionName.TypeOfService);
			Console.WriteLine("TCP TypeOfService {0}", option);
		}
		static void Main(string[] args)
		{
			Console.WriteLine("Gniazdo TCP");
			Socket s = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
			ListTCPDefaultOptions(s);
			s.Close();
			Console.WriteLine("Gniazdo UDP");
			s = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);
			ListUDPDefaultOptions(s);
			s.Close();
			s = new Socket(AddressFamily.InterNetwork, SocketType.Raw, ProtocolType.Raw);
			ListRawDefaultOptions(s);
			s.Close();
		}
	}
}
